
qz.security.setCertificatePromise(function(resolve, reject) {
	resolve("-----BEGIN CERTIFICATE-----\n" +
	"MIID9zCCAt+gAwIBAgIJAPDkv4zZtPLHMA0GCSqGSIb3DQEBCwUAMIGQMQswCQYD\n" +
	"VQQGEwJCUjEVMBMGA1UECAwMU8ODwqNvIFBhdWxvMRUwEwYDVQQHDAxTw4PCo28g\n" +
	"UGF1bG8xDDAKBgNVBAoMA1RXeDEMMAoGA1UECwwDVFd4MRIwEAYDVQQDDAlsb2Nh\n" +
	"bGhvc3QxIzAhBgkqhkiG9w0BCQEWFGpvbmF0aGFub0B0d3guY29tLmJyMCAXDTE4\n" +
	"MDkyNjE3NTE0N1oYDzIwNTAwMzIxMTc1MTQ3WjCBkDELMAkGA1UEBhMCQlIxFTAT\n" +
	"BgNVBAgMDFPDg8KjbyBQYXVsbzEVMBMGA1UEBwwMU8ODwqNvIFBhdWxvMQwwCgYD\n" +
	"VQQKDANUV3gxDDAKBgNVBAsMA1RXeDESMBAGA1UEAwwJbG9jYWxob3N0MSMwIQYJ\n" +
	"KoZIhvcNAQkBFhRqb25hdGhhbm9AdHd4LmNvbS5icjCCASIwDQYJKoZIhvcNAQEB\n" +
	"BQADggEPADCCAQoCggEBAMFAsKhh9rJdZwMfhKA7DVcUr8zu3ifUZfsOcKH5dm9H\n" +
	"+wMCSBjy4gBNQgRnMzymGTNcrlZSTOTbbrIzU7tluhBo4RQBN2VJ/j/THGAjTWHR\n" +
	"p0CuSBblk3YQntRR7s6QazMEobQSZc8kz4Xww7yc4/iwqQBDLHVSafPDNhGC4MfX\n" +
	"LHK0bisEvTJ1klYqwiFmFFHZzMIIl8gmoljsmPFcJKYLC2E0eqpGPj9Zui92wsgv\n" +
	"cvVnLUAOZc8fyCMothPkC9RiFHEQ0ZCP1VyN6BMo/mfSrv2VRVFs3uj8zpo+9tfE\n" +
	"fv9c5/g3FCRNTmCmPaNvWmiXvnnah3hC2LriQrVO9v8CAwEAAaNQME4wHQYDVR0O\n" +
	"BBYEFBH1Zwjk61o+rwN8REpaO6uF+e1RMB8GA1UdIwQYMBaAFBH1Zwjk61o+rwN8\n" +
	"REpaO6uF+e1RMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQELBQADggEBAIR9+peP\n" +
	"VBbOot/MPQu5Z7Dweh+wp6qkPRD5BOfvSdtPrIgi9WK/c9T4q4DioLe92T5OhGUZ\n" +
	"Hc44O2OvJLc5+AvZWkXEqtntzLXdoTacKlZTsGSwoZD03OHt9I18M4d9BsE0ngp2\n" +
	"jISL8R+uHqpRfcGNoSbC/tARKZsR/3R4cOGPNqlAUo+/+nxxTnKTfL8Q2EYgnw/2\n" +
	"v8arMR+cPhPRBEgYZGwtivm+MU18K+COz69NNx8iADmDavWm4Feexnsdl4kYo5Ea\n" +
	"vDaEsNlXrnfQfYOchPvMqNPWrQxPqfrwp25OtiBbhTamkg/aOfm7LUO/7+CNfKQ9\n" +
	"VOetuRF/hubPJls=\n" +
	"-----END CERTIFICATE-----");
});

var privateKey = "-----BEGIN PRIVATE KEY-----\n" +
"MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDBQLCoYfayXWcD\n" +
"H4SgOw1XFK/M7t4n1GX7DnCh+XZvR/sDAkgY8uIATUIEZzM8phkzXK5WUkzk226y\n" +
"M1O7ZboQaOEUATdlSf4/0xxgI01h0adArkgW5ZN2EJ7UUe7OkGszBKG0EmXPJM+F\n" +
"8MO8nOP4sKkAQyx1UmnzwzYRguDH1yxytG4rBL0ydZJWKsIhZhRR2czCCJfIJqJY\n" +
"7JjxXCSmCwthNHqqRj4/WbovdsLIL3L1Zy1ADmXPH8gjKLYT5AvUYhRxENGQj9Vc\n" +
"jegTKP5n0q79lUVRbN7o/M6aPvbXxH7/XOf4NxQkTU5gpj2jb1pol7552od4Qti6\n" +
"4kK1Tvb/AgMBAAECggEAdqGmkIcqsM3Dmdg0S0RU6RsK3GvaNmsde2Oe4t/Hw4JV\n" +
"ZcB1z9Lxx6ullhxgCKASIkSHxPfauja2GnCFuyk0cjRfzy77+ZLVoAqRhbbGHwFb\n" +
"gco6+MtPnY+QYNg3F9jx5ay3M1qD4wg+2IM3NUa+b4DLDh0uYosH/ZrdSxyjriio\n" +
"MTEzct3X9kdIYSu1rYDOl++Gtt8I/Y1WyCxSDN42xBPIIyqSUe40Wv7YjJoHYlIL\n" +
"WWwPhTnlBOBRp9dVk2xnL2uhrnE5jAq5SSH5xxP1pFUmdGrebnw3By7XMlXFWoFE\n" +
"UQ2V/vS0erpYu1LQruawMDl1fH5m6yKFYZEDFVS/UQKBgQDtvydMKTEc1UqFoA48\n" +
"EBT4cKFLgL1KthKaTFjz34zxpGuo/+D+BD6fublNmFVas5V7fKYIoxUJCnFGaSP4\n" +
"WnqoTsCfUbCgBtXO8G8KPtOfIIfzvZVZRV6Z7dEB6NiPrglziMYBwejiJ/eS10lN\n" +
"FoAq785m9B5jZjktd35Lq4zfCQKBgQDQFwTnfYA/9Bpayr2SfMN83R2cEtmxQz0X\n" +
"ZN9g+acc8w9baanw+nQ89ZY4bYygoOOrAGQUsMR7cMyTeqWe3TE/jtoqidVkVys8\n" +
"7Kz6RDa/ZL+tOMZ9AY8B7DL+dxf/OVEQ4fhOwCRKXEzaV9p8kB60pHw1WH4vhvqU\n" +
"FNP8ZM+fxwKBgGYavFPXNQJ/D9xHmxVsirUQGhWFGsalX2Po+iLylWOKC7qu+f/d\n" +
"7s9GQjDzBWVIzyATrnLzJyuU0oU8znfw09DI0a0atlJj3Rtc4zNxPA2RORITD7sh\n" +
"MbnGCwdY6vj585Es4m0KzGukYo0r7I0w5qaKCwjoOszRsCi4swLokD2RAoGAMPX5\n" +
"lW4WCvYobUxepmTsqihsmxhkWCz15tc5J9wV0d3usxd9gNGtH9q46bX87J5ucwG4\n" +
"ipW85T55JAorheGNgOLfujqMFvvblI4rdQcvyoCuCNfe+/Kt70ngBbeH0eluhYZl\n" +
"okHbSBPHkWgyZDSUxPQetX6I0i30L3tnFW+y2mkCgYEA3PwyFpG3epAdtyhKhmxg\n" +
"PQa6lWC4jYUgZf72wBludwGXOW1v96yQxZjo0c0HptvxAfXwWNs5sQ6PJHbe6HqM\n" +
"hMnC7KITh8OtzUSXaeCMsO/oEafpLN/zhjQNQw/wQLU/WCrH7PkM9zJhbOYb8mPd\n" +
"Fh9IDDtS8NE8ALYo1VUKk5Q=\n" +
"-----END PRIVATE KEY-----";

 
qz.security.setSignaturePromise(function(toSign) {
	return function(resolve, reject) {
		try {
			var pk = KEYUTIL.getKey(privateKey);
			var sig = new KJUR.crypto.Signature({"alg": "SHA1withRSA"});
			sig.init(pk); 
			sig.updateString(toSign);
			var hex = sig.sign();
			//console.log("DEBUG: \n\n" + stob64(hextorstr(hex)));
			resolve(stob64(hextorstr(hex)));
		} catch (err) {
			console.error(err);
			reject(err);
		}
	};
});


//Conecta ao QZ caso não exista conexão ativa ainda
function connectQz(){
	return new RSVP.Promise(function(resolve, reject) {
        if (qz.websocket.isActive()) {	// if already active, resolve immediately
		   resolve();
        } else {
			let options = { retries: 0, delay: 0};
           // try to connect once before firing the mimetype launcher
		   qz.websocket.connect(options).then(resolve, function retry() {
                //Caso não consiga se conectar, tenta abrir o QZ automaticamente
                window.location.assign("qz:launch");
				options.delay = 1;
				options.retries = 2;
                qz.websocket.connect({ ...options, delay: 1 }).then(resolve, reject);
            });
        }
    });
}

function printQz(disp, arquivo, fila, caminho, callback){
	  qz.websocket.connect().then(function() {
		return qz.printers.find(fila)               //Procura a impressora pelo nome
	  }).then(function(printer) {
		var config = qz.configs.create(printer);       //Cria uma configuração padrão para a impressora encontrada
		var data = [{
					 type: 'raw',
					 format: 'base64',
					 data: arquivo
				  }];
		qz.print(config, data);
		if (typeof callback === 'function') {
			callback(); 
		}
	  }).catch(function(e) { 
		alert("Impressora "+fila+" nao encontrada!");
		//Lista todas as impressoras disponíveis na rede
		qz.printers.find().then(function(data) {
			var list = '';
			for(var i = 0; i < data.length; i++) {
				list += data[i] + " - ";
			}
			console.log("Impressoras disponíveis: "+list);
			if (typeof callback === 'function') {
				callback(); 
			}
		})
	
	  });
}

	